/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.pa.PAActivityLoadOptionsPanel;
import filenet.vw.apps.taskman.pa.PACaseLoadOptionsPanel;
import filenet.vw.apps.taskman.pa.PACubeListCellRenderer;
import filenet.vw.apps.taskman.pa.PACubeListItem;
import filenet.vw.apps.taskman.pa.PACubeOptionsPanel;
import filenet.vw.apps.taskman.pa.PADataFieldCubesPanel;
import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.PAQueueLoadOptionsPanel;
import filenet.vw.apps.taskman.pa.PAWorkLoadOptionsPanel;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PAAddRemoveCubesPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
IVWMouseActionListener,
KeyListener {
    private PADataFieldWizard m_wizard = null;
    private PADataFieldCubesPanel m_cubesPanel = null;
    private JLabel m_availableLabel = null;
    private JLabel m_selectedLabel = null;
    private JList m_availableList = null;
    private JList m_selectedList = null;
    private JScrollPane m_availableScrollPane = null;
    private JButton m_addButton = null;
    private JButton m_removeButton = null;
    private boolean m_bSortAvailable = true;
    private boolean m_bSortSelected = true;
    private boolean m_bMaintaimAvailableSorted = true;
    private boolean m_bMaintainSelectedSorted = true;
    private EventListenerList m_listUpdateListenerList = new EventListenerList();

    public PAAddRemoveCubesPanel(PADataFieldWizard wizard, PADataFieldCubesPanel cubesPanel) {
        this.setLayout(new GridBagLayout());
        this.addControls();
        this.m_wizard = wizard;
        this.m_cubesPanel = cubesPanel;
    }

    public void initializeLists(int cubes, int cubeOptions, boolean listEditable) {
        PACubeListItem item;
        boolean optionsEditable;
        ArrayList<PACubeListItem> aItems = new ArrayList<PACubeListItem>();
        ArrayList<PACubeListItem> sItems = new ArrayList<PACubeListItem>();
        this.m_addButton.setVisible(listEditable);
        this.m_removeButton.setVisible(listEditable);
        this.m_availableScrollPane.setVisible(listEditable);
        this.m_availableLabel.setVisible(listEditable);
        if ((0x20 & cubes) == 32) {
            optionsEditable = this.m_wizard != null && this.m_wizard.isNewDataField();
            item = new PACubeListItem(VWResource.QueueLoad, 32, new PAQueueLoadOptionsPanel(cubeOptions, optionsEditable));
            sItems.add(item);
        } else {
            optionsEditable = this.m_wizard != null;
            item = new PACubeListItem(VWResource.QueueLoad, 32, new PAQueueLoadOptionsPanel(cubeOptions, optionsEditable));
            aItems.add(item);
        }
        if ((8 & cubes) == 8) {
            optionsEditable = this.m_wizard != null && this.m_wizard.isNewDataField();
            item = new PACubeListItem(VWResource.WorkLoad, 8, new PAWorkLoadOptionsPanel(cubeOptions, optionsEditable));
            sItems.add(item);
        } else {
            optionsEditable = this.m_wizard != null;
            item = new PACubeListItem(VWResource.WorkLoad, 8, new PAWorkLoadOptionsPanel(cubeOptions, optionsEditable));
            aItems.add(item);
        }
        if ((0x400 & cubes) == 1024) {
            optionsEditable = this.m_wizard != null && this.m_wizard.isNewDataField();
            item = new PACubeListItem(VWResource.CaseLoad, 1024, new PACaseLoadOptionsPanel(cubeOptions, optionsEditable));
            sItems.add(item);
        } else {
            optionsEditable = this.m_wizard != null;
            item = new PACubeListItem(VWResource.CaseLoad, 1024, new PACaseLoadOptionsPanel(cubeOptions, optionsEditable));
            aItems.add(item);
        }
        if ((0x800 & cubes) == 2048) {
            optionsEditable = this.m_wizard != null && this.m_wizard.isNewDataField();
            item = new PACubeListItem(VWResource.TaskLoad, 2048, new PAActivityLoadOptionsPanel(cubeOptions, optionsEditable));
            sItems.add(item);
        } else {
            optionsEditable = this.m_wizard != null;
            item = new PACubeListItem(VWResource.TaskLoad, 2048, new PAActivityLoadOptionsPanel(cubeOptions, optionsEditable));
            aItems.add(item);
        }
        item = new PACubeListItem(VWResource.WorkItemProcessingTime, 2);
        if ((2 & cubes) == 2) {
            sItems.add(item);
        } else {
            aItems.add(item);
        }
        item = new PACubeListItem(VWResource.Routing, 128);
        if ((0x80 & cubes) == 128) {
            sItems.add(item);
        } else {
            aItems.add(item);
        }
        item = new PACubeListItem(VWResource.WorkflowInProgress, 64);
        if ((0x40 & cubes) == 64) {
            sItems.add(item);
        } else {
            aItems.add(item);
        }
        item = new PACubeListItem(VWResource.WorkItemInProgress, 1);
        if ((1 & cubes) == 1) {
            sItems.add(item);
        } else {
            aItems.add(item);
        }
        item = new PACubeListItem(VWResource.CaseInProgress, 256);
        if ((0x100 & cubes) == 256) {
            sItems.add(item);
        } else {
            aItems.add(item);
        }
        item = new PACubeListItem(VWResource.TaskInProgress, 512);
        if ((0x200 & cubes) == 512) {
            sItems.add(item);
        } else {
            aItems.add(item);
        }
        this.setAvailableAndSelectedItems(aItems.toArray(), sItems.toArray());
        if (sItems.size() > 0) {
            this.m_selectedList.setSelectedIndex(0);
        }
        if (this.m_cubesPanel.isExposedToFactTablesOnly()) {
            this.m_availableLabel.setText(VWResource.AvailableFactTables);
            this.m_selectedLabel.setText(VWResource.SelectedFactTables);
        } else {
            this.m_availableLabel.setText(VWResource.AvailableCubes);
            this.m_selectedLabel.setText(VWResource.SelectedCubes);
        }
    }

    public int getCubes() {
        int cubes = 0;
        Object[] items = this.getSelectedItems();
        for (int i = 0; i < items.length; ++i) {
            cubes += ((PACubeListItem)items[i]).getOrdinal();
        }
        return cubes;
    }

    public int getCubeOptions() {
        int cubeOptions = 0;
        Object[] items = this.getSelectedItems();
        for (int i = 0; i < items.length; ++i) {
            PACubeOptionsPanel optionsPanel = ((PACubeListItem)items[i]).getOptionsPanel();
            if (optionsPanel == null) continue;
            cubeOptions += optionsPanel.getOptionsValue();
        }
        return cubeOptions;
    }

    public void performValidation() throws Exception {
        Object[] items = this.getSelectedItems();
        if (items == null || items.length == 0) {
            throw new VWException("vw.apps.taskman.pa.PAAddRemoveCubesPanel.AtLeastOneCubeMustBeSelected", "At least one cube must be selected.");
        }
        for (int i = 0; i < items.length; ++i) {
            PACubeOptionsPanel optionsPanel = ((PACubeListItem)items[i]).getOptionsPanel();
            if (optionsPanel == null || this.m_wizard == null || !this.m_wizard.isMeasure() || optionsPanel.getOptionsValue() != 0) continue;
            throw new VWException("vw.apps.taskman.pa.PAAddRemoveCubesPanel.AtLeastOneCubeOptionMustBeSelected", "At least one option must be selected for cube {0}.", ((PACubeListItem)items[i]).getName());
        }
    }

    public Object[] getSelectedItems() {
        ListModel listModel = this.m_selectedList.getModel();
        Object[] items = new Object[listModel.getSize()];
        for (int i = 0; i < listModel.getSize(); ++i) {
            items[i] = listModel.getElementAt(i);
        }
        return items;
    }

    public Object[] getSelectedItemsInSelectedList() {
        ListModel listModel = this.m_selectedList.getModel();
        Object[] items = new Object[listModel.getSize()];
        for (int i = 0; i < listModel.getSize(); ++i) {
            items[i] = listModel.getElementAt(i);
        }
        return items;
    }

    public Object[] getAvailableItems() {
        ListModel listModel = this.m_availableList.getModel();
        Object[] items = new Object[listModel.getSize()];
        for (int i = 0; i < listModel.getSize(); ++i) {
            items[i] = listModel.getElementAt(i);
        }
        return items;
    }

    public void addListUpdateListener(IVWListUpdateListener listener) {
        this.m_listUpdateListenerList.add(IVWListUpdateListener.class, listener);
    }

    public void removeListUpdateListener(IVWListUpdateListener listener) {
        this.m_listUpdateListenerList.remove(IVWListUpdateListener.class, listener);
    }

    public int compareTo(Object obj1, Object obj2) {
        String name1 = null;
        String name2 = null;
        int result = 0;
        name1 = obj1 instanceof String ? (String)obj1 : (obj1 instanceof IVWSortItem ? ((IVWSortItem)obj1).getName() : obj1.toString());
        name2 = obj2 instanceof String ? (String)obj2 : (obj2 instanceof IVWSortItem ? ((IVWSortItem)obj2).getName() : obj2.toString());
        result = VWStringUtils.compareIgnoreCase(name1, name2);
        return result;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.m_availableList)) {
            this.m_selectedList.removeListSelectionListener(this);
            this.m_selectedList.clearSelection();
            this.m_selectedList.addListSelectionListener(this);
            this.updateTheMainButtonsState();
            Object[] selectedObjects = this.m_availableList.getSelectedValues();
            this.fireListUpdatedEvent(5, selectedObjects);
        } else if (event.getSource().equals(this.m_selectedList)) {
            this.m_availableList.removeListSelectionListener(this);
            this.m_availableList.clearSelection();
            this.m_availableList.addListSelectionListener(this);
            this.updateTheMainButtonsState();
            Object[] selectedObjects = this.m_selectedList.getSelectedValues();
            this.fireListUpdatedEvent(6, selectedObjects);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        if (object.equals(this.m_addButton) && this.m_addButton.isEnabled()) {
            this.addSelectedItems();
        } else if (object.equals(this.m_removeButton) && this.m_removeButton.isEnabled()) {
            this.removeSelectedItems();
        }
        this.getRootPane().setCursor(Cursor.getDefaultCursor());
    }

    public void doubleClickedItem(MouseEvent event) {
        Object object = event.getSource();
        if (this.m_wizard != null) {
            if (object.equals(this.m_availableList) && this.m_addButton.isEnabled()) {
                this.addSelectedItems();
            } else if (object.equals(this.m_selectedList) && this.m_removeButton.isEnabled()) {
                this.removeSelectedItems();
            }
        }
    }

    public void createPopup(MouseEvent event) {
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        if (event.getKeyCode() == 10) {
            this.addSelectedItems();
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    private void addControls() {
        PACubeListCellRenderer cellRenderer = new PACubeListCellRenderer();
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_availableLabel = new JLabel();
        this.add((Component)this.m_availableLabel, gbCons);
        gbCons.anchor = 23;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        this.m_availableList = new JList(new VWSortedListModel());
        this.m_availableList.setFixedCellWidth(50);
        this.m_availableList.setCellRenderer(cellRenderer);
        this.m_availableList.setVisibleRowCount(6);
        this.m_availableList.setSelectionMode(0);
        this.m_availableList.addListSelectionListener(this);
        this.m_availableList.addMouseListener(new VWMouseAdapter(this));
        this.m_availableScrollPane = new JScrollPane(this.m_availableList);
        this.add((Component)this.m_availableScrollPane, gbCons);
        int addRemoveGridy = gbCons.gridy;
        gbCons.anchor = 10;
        gbCons.fill = 3;
        gbCons.gridx = 1;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 1.0;
        this.add((Component)this.createAddRemoveButtonPanel(), gbCons);
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 2;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        this.m_selectedLabel = new JLabel();
        this.add((Component)this.m_selectedLabel, gbCons);
        gbCons.anchor = 23;
        gbCons.fill = 1;
        gbCons.gridx = 2;
        gbCons.gridy = 1;
        gbCons.gridwidth = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.gridheight = 1;
        this.m_selectedList = new JList(new VWSortedListModel());
        this.m_selectedList.setFixedCellWidth(50);
        this.m_selectedList.setCellRenderer(cellRenderer);
        this.m_selectedList.setVisibleRowCount(6);
        this.m_selectedList.setSelectionMode(0);
        this.m_selectedList.addListSelectionListener(this);
        this.m_selectedList.addMouseListener(new VWMouseAdapter(this));
        this.add((Component)new JScrollPane(this.m_selectedList), gbCons);
    }

    private JPanel createAddRemoveButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = -1;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(3, 3, 3, 3);
        this.m_addButton = new JButton(VWImageLoader.createImageIcon("add.gif"));
        this.m_addButton.setToolTipText(VWResource.Add);
        this.m_addButton.setMargin(new Insets(1, 1, 1, 1));
        this.m_addButton.addActionListener(this);
        panel.add((Component)this.m_addButton, gbCons);
        this.m_removeButton = new JButton(VWImageLoader.createImageIcon("remove.gif"));
        this.m_removeButton.setToolTipText(VWResource.Remove);
        this.m_removeButton.setMargin(new Insets(1, 1, 1, 1));
        this.m_removeButton.addActionListener(this);
        panel.add((Component)this.m_removeButton, gbCons);
        return panel;
    }

    private void addSelectedItems() {
        this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        Object[] items = this.removeSelectedItems(this.m_availableList);
        if (items == null) {
            return;
        }
        this.addSelectedItems(items, this.m_selectedList);
        this.onAddItemsAction(items);
        this.m_addButton.setEnabled(false);
        this.getRootPane().setCursor(Cursor.getDefaultCursor());
    }

    private void onAddItemsAction(Object[] items) {
        this.fireListUpdatedEvent(1, items);
        this.fireListUpdatedEvent(6, items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectedItems(Object[] items, JList list) {
        try {
            this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
            if (items == null || items.length == 0) {
                return;
            }
            VWSortedListModel listModel = (VWSortedListModel)list.getModel();
            int[] indices = new int[items.length];
            boolean bPerformMergeSort = false;
            if (list == this.m_selectedList && (this.m_bSortSelected || this.m_bMaintainSelectedSorted)) {
                bPerformMergeSort = true;
            } else if (list == this.m_availableList && (this.m_bSortAvailable || this.m_bMaintaimAvailableSorted)) {
                bPerformMergeSort = true;
            }
            if (bPerformMergeSort) {
                int startPos = 0;
                for (int i = 0; i < items.length; ++i) {
                    indices[i] = this.insertToList(listModel, items[i], startPos);
                    startPos = indices[i];
                }
            } else {
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] == null) continue;
                    listModel.addElement(items[i]);
                    indices[i] = listModel.getSize() - 1;
                }
            }
            list.removeListSelectionListener(this);
            list.setSelectedIndices(indices);
            this.updateTheMainButtonsState();
            list.addListSelectionListener(this);
        }
        finally {
            this.getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void removeSelectedItems() {
        this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        Object[] items = this.removeSelectedItems(this.m_selectedList);
        if (items == null) {
            return;
        }
        this.addSelectedItems(items, this.m_availableList);
        items = this.onRemoveItemsAction(items);
        this.m_removeButton.setEnabled(false);
        this.getRootPane().setCursor(Cursor.getDefaultCursor());
    }

    private Object[] onRemoveItemsAction(Object[] items) {
        this.fireListUpdatedEvent(2, items);
        this.fireListUpdatedEvent(5, items);
        return items;
    }

    private Object[] removeSelectedItems(JList list) {
        Object[] items = null;
        int[] indices = list.getSelectedIndices();
        if (indices.length == 0) {
            return items;
        }
        items = new Object[indices.length];
        VWSortedListModel listModel = (VWSortedListModel)list.getModel();
        for (int i = indices.length - 1; i >= 0; --i) {
            items[i] = listModel.getElementAt(indices[i]);
            int fromIdx = indices[i];
            int toIdx = indices[i];
            while (i > 0 && indices[i - 1] == fromIdx - 1) {
                fromIdx = indices[--i];
                items[i] = listModel.getElementAt(indices[i]);
            }
            listModel.removeRange(fromIdx, toIdx);
            toIdx = fromIdx - 1;
        }
        return items;
    }

    private void updateTheMainButtonsState() {
        int[] selectedIndices = this.m_availableList.getSelectedIndices();
        this.m_addButton.setEnabled(selectedIndices.length > 0);
        selectedIndices = this.m_selectedList.getSelectedIndices();
        this.m_removeButton.setEnabled(selectedIndices.length > 0);
    }

    private void setAvailableAndSelectedItems(Object[] availableItems, Object[] selectedItems) {
        if (this.m_addButton != null) {
            this.m_addButton.setEnabled(false);
        }
        if (this.m_removeButton != null) {
            this.m_removeButton.setEnabled(false);
        }
        VWSortedListModel availableListModel = new VWSortedListModel();
        VWSortedListModel selectedListModel = new VWSortedListModel();
        if (availableItems != null) {
            if (selectedItems == null) {
                for (int i = 0; i < availableItems.length; ++i) {
                    availableListModel.addElement(availableItems[i]);
                }
            } else {
                int arrayPosition;
                int i;
                for (i = 0; i < selectedItems.length; ++i) {
                    arrayPosition = this.isInArray(selectedItems[i], availableItems);
                    if (arrayPosition == -1) {
                        selectedListModel.addElement(selectedItems[i]);
                        continue;
                    }
                    selectedListModel.addElement(availableItems[arrayPosition]);
                }
                for (i = 0; i < availableItems.length; ++i) {
                    arrayPosition = this.isInArray(availableItems[i], selectedItems);
                    if (arrayPosition != -1) continue;
                    availableListModel.addElement(availableItems[i]);
                }
            }
        } else if (selectedItems != null) {
            for (int i = 0; i < selectedItems.length; ++i) {
                selectedListModel.addElement(selectedItems[i]);
            }
        }
        if (this.m_bSortAvailable) {
            availableListModel.sort();
        }
        this.m_availableList.setModel(availableListModel);
        if (this.m_bSortSelected) {
            selectedListModel.sort();
        }
        this.m_selectedList.setModel(selectedListModel);
    }

    private int isInArray(Object item, Object[] items) {
        if (items == null || items.length < 1) {
            return -1;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || this.compareTo(item, items[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    private int insertToList(VWSortedListModel listModel, Object item, int startPos) {
        int idx = listModel.size();
        for (int i = startPos; i < listModel.size(); ++i) {
            if (this.compareTo(item, listModel.elementAt(i)) > 0) continue;
            idx = i;
            break;
        }
        listModel.insertElementAt(item, idx);
        return idx;
    }

    private void fireListUpdatedEvent(int nEventType, Object[] items) {
        Object[] listeners = this.m_listUpdateListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == null || !listeners[i].equals(IVWListUpdateListener.class)) continue;
            ((IVWListUpdateListener)listeners[i + 1]).listUpdated(this, nEventType, items);
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:39:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.10  $";
    }
}

